function deepcopy(object)
    local lookup_table = {}
    local function _copy(object)
    	if(object==nil) then
    		return(nil)
        elseif type(object) ~= "table" then
		return object
        elseif lookup_table[object] then
		return lookup_table[object]
        end
        local new_table = {}
        lookup_table[object] = new_table
        for index, value in pairs(object) do
		new_table[_copy(index)] = _copy(value)
        end
	return setmetatable(new_table, getmetatable(object))
    end
    return _copy(object)
end

levelConst = {}
LEVEL_EASY 	= "_easy"
LEVEL_NORMAL 	= "_"
LEVEL_HARD 	= "_hard"

function initAIConst()
	local easyLevel =
	{
		lvl			= LEVEL_EASY,

		-----------------------------
		--   

		maxMoveDist		= 15,		--    ()
		medMoveDist		= 10,           --
		defMoveDist		= 5,            --
		minMoveDist		= 1,            --
		sniperMaxMoveDist	= 5,		--    ()
		sniperMedMoveDist	= 4,		--
		sniperDefMoveDist	= 3,		--
		sniperMinMoveDist	= 1,		--
		maxStrategy		= 3,		--   (TB)
		medMoveMistake		= 0.3,		--        
		smallMoveMistake	= 0.1,		--        
		rotateMistake		= 80,		--     ,        
		hitBreathPenalty	= 200,		--      (   )
		boredInterval 		= 180,		-- ,       
		useOneGrenadePerTurn	= true,

		----------------------------------
		--    
				
		RTMinBreathForJob	= 2000,		--  ,      (RT)
		TBMinBreathForJob	= 1000,		--  ,      (TB)
		TBBreathForWalk		= 3300,
		tooCloseDist		= 10,		--       
		moraleTresholdPoseUp	= 70,		--       
		moraleTresholdPoseDown	= 55,		--       
		moraleTresholdFlee	= 65,		-- ...      melee
		strafeProb		= 0.3,		--      
		forcedMeleeDist		= 5,		--       melee
		forcedMeleeProb		= 0.8,		--    melee
		turnForVisibleReport	= 2,		--  ,  RT,        
		visibleReportProb	= 0.5,		--      
		soldierMaxMissTries	= 2,		--       ()
		sniperMaxMissTries	= 3,		--       ()
		sniperMaxAttacks	= 5,		--       ()
		tryWalkAroundProb	= 0.5,		--    ( -  )
		minGrenadeRange 	= 8,		--     	
		useGrenadeProb 		= 0.7,		-- 1-   
		reloadTreshold		= 50,           --         
		tryHealAlly		= false,	--    ?
		mayCheckLoot		= false,	--      ?
		tryKillDyingEnemy	= false,	--      ?
		attackDyingEnemyProb	= 0.2,		--    
		psychoProcessed		= 0.05,		--  ""    ( )
		maxGrenadeMistake	= 5,		--     ( )
		healthPercentToBandage	= 0,

		----------------------------------------
		--     

		RTKnownStalkers		= 3,		--      RT
		TBKnownStalkers		= 3,		--      RT

		----------------------------
		--    

		dangerSoundShotDist	= 70,		-- ,      
		dangerSoundBlastDist	= 90,		-- ,      
		dangerSoundBulletDist	= 5,		-- ,      
		forgetSoundInterval	= 120,		--   ,     
		RTSoundStalkers		= 3,		--     RT
		TBSoundStalkers		= 3,            --     TB
		RTSoundStalkMode	= "walk",	--      RT
		TBSoundStalkMode	= "walk",	--      TB

		----------------------------------------------------
		--   (     )

		roamInterval		= 60,		--  ,     
		roamRadius 		= 15,		--  
		lazyRoamInterval	= 30,		--  ,     ""  (..   )
		lazyRoamRadius 		= 15,		--  "" 
		lazyRoamIntensivity	= 0.12,		--  "" 
		lazyRoamLowTime		= 4,		--   ""  "" 
		lazyRoamUpTime		= 9,		--  ...

		------------------------------
		--     

		mpAllyCorpseSighted	= -2,		--     
		mpAllyHit		= -2,		--     
		mpAllyKilled		= -4,		--     ()
		mpAllyKilledAll		= -2,		--       ()
		mpHit			= -5,           --   
		mpKilledAll		= -10,		--     
		mbEnemyHit		= 1,		--     
		mbEnemyKilled		= 2,		--    
		mbEnemyKilledAll	= 1,		--      

		-------------------------------------
		--    

		leaderOptDist		= 25,		--     
		leaderMaxCmdDist	= 30,		--  ,     
		leaderFarDist		= 40,		--         

		----------------------------------
		--  ( )

		leaderAllowDiedProb	= 0.6,		--           
		leaderRetreatProb	= 0.6,		--         100 ( -  )
		leaderRetreatTurns	= 2,		--       

		---------------------------------------------
		--  (  )

		surroundTurns		= 2,		--        
		surManyEnemiesSoldier	= 0.3,		--     -  (  100, )
		surBadHealthSoldier	= 0.3,		--      (  100, ) 
		surManyEnemiesSniper	= 0.5,		--     -  (  100, , , )
		surBadHealthSniper	= 0.4,		--      (  100, , , ) 
		retreatHealth		= 50,		--    
		retreatEnemies		= 5,		--     ()
		retreatEnemiesSniper	= 3,		--     (,,)
	}
	local normalLevel =
	{
		lvl			= LEVEL_NORMAL,
		-----------------------------
		--   

		maxMoveDist		= 15,		--    ()
		medMoveDist		= 10,           --
		defMoveDist		= 5,            --
		minMoveDist		= 1,            --
		sniperMaxMoveDist	= 5,		--    ()
		sniperMedMoveDist	= 4,		--
		sniperDefMoveDist	= 3,		--
		sniperMinMoveDist	= 1,		--
		maxStrategy		= 3,		--   (TB)
		medMoveMistake		= 0.3,		--        
		smallMoveMistake	= 0.1,		--        
		rotateMistake		= 80,		--     ,        
		hitBreathPenalty	= 200,		--      (   )
		boredInterval 		= 150,		-- ,       
		useOneGrenadePerTurn	= false,

		----------------------------------
		--    
				
		RTMinBreathForJob	= 2000,		--  ,      (RT)
		TBMinBreathForJob	= 1000,		--  ,      (TB)
		TBBreathForWalk		= 3300,
		tooCloseDist		= 10,		--       
		moraleTresholdPoseUp	= 60,		--       
		moraleTresholdPoseDown	= 45,		--       
		moraleTresholdFlee	= 55,		-- ...      melee
		strafeProb		= 0.3,		--      
		forcedMeleeDist		= 6,		--       melee
		forcedMeleeProb		= 0.8,		--    melee
		turnForVisibleReport	= 1,		--  ,  RT,        
		visibleReportProb	= 0.75,		--      
		soldierMaxMissTries	= 2,		--       ()
		sniperMaxMissTries	= 3,		--       ()
		sniperMaxAttacks	= 5,		--       ()
		tryWalkAroundProb	= 0.5,		--    ( -  )
		minGrenadeRange 	= 8,		--     	
		useGrenadeProb 		= 0.6,		-- 1-   
		reloadTreshold		= 50,           --         
		tryHealAlly		= true,		--    ?
		mayCheckLoot		= true,		--      ?
		tryKillDyingEnemy	= true,		--      ?
		attackDyingEnemyProb	= 0.3,		--    
		psychoProcessed		= 0.1,		--  ""    ( )
		maxGrenadeMistake	= 4,		--     ( )
		healthPercentToBandage	= 40,

		----------------------------------------
		--     

		RTKnownStalkers		= 3,		--      RT
		TBKnownStalkers		= 5,		--      RT

		----------------------------
		--    

		dangerSoundShotDist	= 80,		-- ,      
		dangerSoundBlastDist	= 100,          -- ,      
		dangerSoundBulletDist	= 5,		-- ,      
		forgetSoundInterval	= 180,		--   ,     
		RTSoundStalkers		= 3,		--     RT
		TBSoundStalkers		= 3,            --     TB
		RTSoundStalkMode	= "walk",	--      RT
		TBSoundStalkMode	= "walk",	--      TB

		----------------------------------------------------
		--   (     )

		roamInterval		= 80,		--  ,     
		roamRadius 		= 15,		--  
		lazyRoamInterval	= 30,		--  ,     ""  (..   )
		lazyRoamRadius 		= 15,		--  "" 
		lazyRoamIntensivity	= 0.12,		--  "" 
		lazyRoamLowTime		= 4,		--   ""  "" 
		lazyRoamUpTime		= 9,		--  ...

		------------------------------
		--     

		mpAllyCorpseSighted	= -1,		--     
		mpAllyHit		= -1,		--     
		mpAllyKilled		= -3,		--     ()
		mpAllyKilledAll		= -1,		--       ()
		mpHit			= -3,           --   
		mpKilledAll		= -8,		--     
		mbEnemyHit		= 1,		--     
		mbEnemyKilled		= 3,		--    
		mbEnemyKilledAll	= 1,		--      

		-------------------------------------
		--    

		leaderOptDist		= 25,		--     
		leaderMaxCmdDist	= 30,		--  ,     
		leaderFarDist		= 40,		--         

		----------------------------------
		--  ( )

		leaderAllowDiedProb	= 0.5,		--           
		leaderRetreatProb	= 0.5,		--         100 ( -  )
		leaderRetreatTurns	= 2,		--       

		---------------------------------------------
		--  (  )

		surroundTurns		= 2,		--        
		surManyEnemiesSoldier	= 0.25,		--     -  (  100, )
		surBadHealthSoldier	= 0.2,		--      (  100, ) 
		surManyEnemiesSniper	= 0.4,		--     -  (  100, , , )
		surBadHealthSniper	= 0.3,		--      (  100, , , ) 
		retreatHealth		= 40,		--    
		retreatEnemies		= 6,		--     ()
		retreatEnemiesSniper	= 4,		--     (,,)
	}
	local hardLevel =
	{
		lvl			= LEVEL_HARD,
		-----------------------------
		--   

		maxMoveDist		= 15,		--    ()
		medMoveDist		= 10,           --
		defMoveDist		= 5,            --
		minMoveDist		= 1,            --
		sniperMaxMoveDist	= 5,		--    ()
		sniperMedMoveDist	= 4,		--
		sniperDefMoveDist	= 3,		--
		sniperMinMoveDist	= 1,		--
		maxStrategy		= 3,		--   (TB)
		medMoveMistake		= 0.3,		--        
		smallMoveMistake	= 0.1,		--        
		rotateMistake		= 80,		--     ,        
		hitBreathPenalty	= 200,		--      (   )
		boredInterval 		= 120,		-- ,       
		useOneGrenadePerTurn	= false,

		----------------------------------
		--    
				
		RTMinBreathForJob	= 2000,		--  ,      (RT)
		TBMinBreathForJob	= 1000,		--  ,      (TB)
		TBBreathForWalk		= 3300,
		tooCloseDist		= 10,		--       
		moraleTresholdPoseUp	= 55,		--       
		moraleTresholdPoseDown	= 40,		--       
		moraleTresholdFlee	= 50,		-- ...      melee
		strafeProb		= 0.3,		--      
		forcedMeleeDist		= 7,		--       melee
		forcedMeleeProb		= 0.9,		--    melee
		turnForVisibleReport	= 1,		--  ,  RT,        
		visibleReportProb	= 0.9,		--      
		soldierMaxMissTries	= 2,		--       ()
		sniperMaxMissTries	= 3,		--       ()
		sniperMaxAttacks	= 5,		--       ()
		tryWalkAroundProb	= 0.5,		--    ( -  )
		minGrenadeRange 	= 8,		--     	
		useGrenadeProb 		= 0.5,		-- 1-   
		reloadTreshold		= 50,           --         
		tryHealAlly		= true,		--    ?
		mayCheckLoot		= true,		--      ?
		tryKillDyingEnemy	= true,		--      ?
		attackDyingEnemyProb	= 0.4,		--    
		psychoProcessed		= 0.15,		--  ""    ( )
		maxGrenadeMistake	= 3,		--     ( )
		healthPercentToBandage	= 50,

		----------------------------------------
		--     

		RTKnownStalkers		= 3,		--      RT
		TBKnownStalkers		= 5,		--      RT

		----------------------------
		--    

		dangerSoundShotDist	= 90,		-- ,      
		dangerSoundBlastDist	= 110,          -- ,      
		dangerSoundBulletDist	= 5,		-- ,      
		forgetSoundInterval	= 200,		--   ,     
		RTSoundStalkers		= 3,		--     RT
		TBSoundStalkers		= 5,            --     TB
		RTSoundStalkMode	= "walk",	--      RT
		TBSoundStalkMode	= "run",	--      TB

		----------------------------------------------------
		--   (     )

		roamInterval		= 90,		--  ,     
		roamRadius 		= 20,		--  
		lazyRoamInterval	= 30,		--  ,     ""  (..   )
		lazyRoamRadius 		= 15,		--  "" 
		lazyRoamIntensivity	= 0.12,		--  "" 
		lazyRoamLowTime		= 4,		--   ""  "" 
		lazyRoamUpTime		= 9,		--  ...

		------------------------------
		--     

		mpAllyCorpseSighted	= 0,		--     
		mpAllyHit		= -1,		--     
		mpAllyKilled		= -2,		--     ()
		mpAllyKilledAll		= -1,		--       ()
		mpHit			= -2,           --   
		mpKilledAll		= -6,		--     
		mbEnemyHit		= 2,		--     
		mbEnemyKilled		= 5,		--    
		mbEnemyKilledAll	= 2,		--      

		-------------------------------------
		--    

		leaderOptDist		= 25,		--     
		leaderMaxCmdDist	= 30,		--  ,     
		leaderFarDist		= 40,		--         

		----------------------------------
		--  ( )

		leaderAllowDiedProb	= 0.33,		--           
		leaderRetreatProb	= 0.4,		--         100 ( -  )
		leaderRetreatTurns	= 2,		--       

		---------------------------------------------
		--  (  )

		surroundTurns		= 2,		--        
		surManyEnemiesSoldier	= 0.2,		--     -  (  100, )
		surBadHealthSoldier	= 0.15,		--      (  100, ) 
		surManyEnemiesSniper	= 0.35,		--     -  (  100, , , )
		surBadHealthSniper	= 0.25,		--      (  100, , , ) 
		retreatHealth		= 33,		--    
		retreatEnemies		= 7,		--     ()
		retreatEnemiesSniper	= 4,		--     (,,)
	}
	levelConst[LEVEL_EASY] 	= deepcopy(easyLevel)
	levelConst[LEVEL_NORMAL]= deepcopy(normalLevel)
	levelConst[LEVEL_HARD] 	= deepcopy(hardLevel)
end

function getAIConst()
	local lvl = "_"..getDifficultyLevel()
	return(levelConst[lvl])
end

function isEasyLevel()
	return(getDifficultyLevel()=="easy")
end

initAIConst()

table_values = 
{
-- really used

	over_head 					=  1.00,		--     
	corner 						=  0.00,		--     

-- for compability only

	max_move_distance 				=  15.00,		--            
	med_move_distance 				=  10.00,		--            
	default_move_distance 				=  5.00,		--             
	min_move_distance 				=  1.00,		--            
	min_grenade_throwing_dist			=  8.00,		--      (  )
	dist_to_not_move_closer				=  10.00,
	max_danger_dist_of_bullet_sound 		=  10.00,		--  ,      
	max_danger_dist_of_grenade_sound 		=  200.00,		--  ,       
	max_danger_dist_of_shot_sound 			=  100.00,		--  ,      
	allow_stalkers 					=  5.00,		--         
	retreat_health 					=  33.00,		--         
	retreat_enemies 				=  3.00,		--         
	reload_threshold 				=  50.00,		--         -   

-- junk below

	default_ai_priority 				=  0.50,		--	      !
	hurt_ai_light_priority 				=  0.90,		--	      !
	hurt_ai_medium_priority 			=  0.91,		--	      !
	underfire_ai_priority 				=  0.80,		--	      !
	shoot_ai_priority 				=  0.70,		--	       !
	remember_ai_priority 				=  0.10,		--	     !
	default_trigger_priority			=  0.10,		--	    
	on_attack_shoot_trigger_finding 		=  0.50,		--	   cover  shoot_position   initiative=1
	on_bullet_orders_canceling			=  0.50,		--	     persistence=1
	only_auto_firing_dist 				= 20.00,		--	  ,       (80%)    (20%)
	max_auto_firing_dist 				= 25.00,		--	  ,       (20%)    (80%)
	max_burst_firing_dist 				= 50.00,		--	  ,       (60%)   (40%)
	mostly_single_firing_dist 			= 75.00,		--	  ,       (20%)   (80%)
	dist_to_run_from_grenade			= 10.00,		--	,      
	grenade_throwing 				=  0.15,		--	     
	max_stand_firing_dist 				= 30.00,		--	  ,     
	max_sit_firing_dist 				= 75.00,		--	  ,     
	time_between_taking_HMG 			=  2.00,		--     ,        HMG
	time_trigger_timeout 				= 10.00,		--  ,  HMG  ,    - 
	time_to_remember_sound 				=  5.00,		--	  ,    
	delay_to_remember_sounds			=  4.00,		--	       
	delay_to_awake 					= 60.00,		--	,   idle- 
	dist_to_trace_sound_point			=  3.00,		--	,       
	dist_to_trigger_NEAR 				=  2.00,		--	,    shoot_position  ""
	fmod_single 					=  0.00,		--	 
	fmod_triple 					=  1.00,		--	  
	fmod_burst 					=  2.00,		--	 
	fmod_grenade 					=  3.00,		--	 
	slot_primary 					=  0.00,		--	   ()
	slot_special 					=  1.00,		--	 .  ()
	slot_secondary 					=  2.00,		--	   ()
	slot_grenade 					=  3.00,		--	  
	slot_medkit 					=  4.00,		--	  
	slot_melee 					=  5.00,		--	    
	max_teammate_hurted_distance 			= 30.00,		--    ,     " "
	buttons_ok 					=  0.00,		--	  messageBox'a: OK
	buttons_ok_cancel 				=  1.00,		--	  messageBox'a: OK & CANCEL
	buttons_yes_no 					=  2.00,		--	  messageBox'a: YES & NO
	button_ok 					=  0.00,		--	  messageBox'a: OK
	button_cancel 					=  3.00,		--	  messageBox'a: CANCEL
	button_yes 					=  4.00,		--	  messageBox'a: YES
	button_no 					=  5.00,		--	  messageBox'a: NO
	subpoints_per_point 				= 25.00,		--  for rpg system
}
